﻿using UnityEditor;

using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class Tetrahedron : ScriptableWizard {

	// Ta zmienna zostanie wyświetlona w kreatorze, tak samo jak
	// zostałaby wyświetlona w panelu Inspector
	public Vector3 size = new Vector3(1,1,1);

	// Ta metoda może mieć dowolną nazwę - ważne jest natomiast, 
	// by była to metoda statyczna i miała atrybut MenuItem
	[MenuItem("GameObject/3D Object/Czworobok")]
	static void ShowWizard() {
		// Pierwszym parametrem jest tytuł, a drugim etykieta na przycisku Utwórz
		ScriptableWizard.DisplayWizard<Tetrahedron>("Utwórz czworobok", "Utwórz");
	}

	// Metoda wywoływana kiedy użytkownik kliknie przycisk w oknie kreatora
	void OnWizardCreate() {

		// Tworzmym obiekt Mesh
		var mesh = new Mesh();

		// Tworzymy cztery punkty
		Vector3 p0 = new Vector3(0,0,0);
		Vector3 p1 = new Vector3(1,0,0);
		Vector3 p2 = new Vector3(0.5f,0,Mathf.Sqrt(0.75f));
		Vector3 p3 = new Vector3(0.5f,Mathf.Sqrt(0.75f),Mathf.Sqrt(0.75f)/3);

		// Skalujemy punkty na podstawie podanej wieklości
		p0.Scale(size);
		p1.Scale(size);
		p2.Scale(size);
		p3.Scale(size);

		// Zapisujemy listę wierzchołków
		mesh.vertices = new Vector3[] {p0,p1,p2,p3};

		// Przekazujemy listę trójkątów łączących poszczególne wierzchołki
		mesh.triangles = new int[] {
			0,1,2,
			0,2,3,
			2,1,3,
			0,3,1
		};

		// Aktualizujemy dodatkowe dane siatki, używając w tym celu powyższych danych
		mesh.RecalculateNormals();
		mesh.RecalculateBounds();

		// Tworzymy obiekt gry na podstawie obiektu Mesh
		var gameObject = new GameObject("Tetrahedron");
		var meshFilter = gameObject.AddComponent<MeshFilter>();
		meshFilter.mesh = mesh;

		var meshRenderer = gameObject.AddComponent<MeshRenderer>();
		meshRenderer.material = new Material(Shader.Find("Standard"));

	}

	// Ta metoda jest wywoływana za każdym razem kiedy użytkownik
	// zmieni wartości w kreatorze
	void OnWizardUpdate() {

		// Sprawdzamy czy podane wartości są prawidłowe
		if (this.size.x <= 0 || 
			this.size.y <= 0 || 
			this.size.z <= 0) {

			// Kiedy zmienna isValid przyjmie wartośc true, użytkownik będzie 
			// mógł kliknąć przycisk umieszczony u dołu okna kreatora
			this.isValid = false;

			// Wyjaśniamy przyczynę problemów
			this.errorString = "Wielkości muszą być większe od zera";

		} else {

			// Użytkownik może kliknąć przycisk u dołu okna kreatora, 
			// a zatem włączamy go i usuwamy komunikat błędu
			this.errorString = null;
			this.isValid = true;
		}
	}


}